/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.ruleGenerators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.classifiers.rules.lad.core.BinaryRule;

public abstract class RuleGenerator
implements Serializable {
    private static final long serialVersionUID = -5645213683696957902L;
    protected double mMinimumPurity = 0.95;
    protected BinaryData mTrainingData;
    private ArrayList<BinaryRule> mBinaryRules = new ArrayList();

    public abstract void generateRules(BinaryData var1);

    public void checkForExceptions() throws Exception {
        if (this.mMinimumPurity <= 0.5 || this.mMinimumPurity > 1.0) {
            throw new Exception("Rule Generator: Minimum Purity must be greater than 0.5 and lest then or equal to 1.0.");
        }
    }

    public void setMinimumPurity(double purity) {
        this.mMinimumPurity = purity;
    }

    public ArrayList<BinaryRule> getRules() {
        return this.mBinaryRules;
    }

    protected void addRule(BinaryRule bRule) {
        if (bRule.getPurity() >= this.mMinimumPurity) {
            this.mBinaryRules.add(bRule);
        }
    }

    public abstract String globalInfo();

    public abstract String[] getOptions();

    public abstract void setOptions(String[] var1) throws Exception;

    public abstract Enumeration listOptions();

    protected class Node {
        private double mDiscrepancy;
        private BinaryData mInstances;

        public Node() {
            this.mInstances = new BinaryData();
        }

        public Node(Node node) {
            this(node.mInstances);
        }

        public Node(BinaryData bInsts) {
            this.mInstances = new BinaryData(bInsts);
        }

        public void addInstance(BinaryInstance bInst) {
            this.mInstances.addInstance(bInst);
        }

        public void removeInstance(BinaryInstance bInst) {
            this.mInstances.removeInstance(bInst);
        }

        public double getDiscrepancy() {
            return this.mDiscrepancy;
        }

        public void setDiscrepancy(double mDiscrepancy) {
            this.mDiscrepancy = mDiscrepancy;
        }

        public ArrayList<BinaryInstance> getPositiveInstances() {
            return this.mInstances.getPositiveInstances();
        }

        public ArrayList<BinaryInstance> getNegativeInstances() {
            return this.mInstances.getNegativeInstances();
        }

        public Integer numPositiveInstances() {
            return this.mInstances.numPositiveInstances();
        }

        public Integer numNegativeInstances() {
            return this.mInstances.numNegativeInstances();
        }

        public double getPurity(boolean aClasse) {
            int np = this.mInstances.numPositiveInstances();
            int nn = this.mInstances.numNegativeInstances();
            if (aClasse) {
                return (double)np / (double)(np + nn);
            }
            return (double)nn / (double)(np + nn);
        }
    }
}

